 ; Ŀ
 ;   Penguin - line and polyline breaker.                                  
 ;   Copyright 1994, 2006, 2010 by Rocket Software Ltd.                    
 ;   Notes: 1. Omnivores and carnivores play, herbivores do not.           
 ;          2. The only creatures which play in the absence of offspring   
 ;             seem to live near or in water.                              
 ;          3. People seem to occupy the middle ground here - maybe we     
 ;             shouldn't have been in such a rush to evolve.               
 ; 

 ; Ŀ
 ;   Subroutine Bliste - takes a list ((ename pt10 pt11) etc.) as an       
 ;   argument and locates breakpoints.                                     
 ; 
 (DEFUN BLISTE (lins / ni blip num goon a1 b2 rat c3 d4 xx fuzz)
  (setq ni 0)                                      ; initialise break counter
 ; Ŀ
 ;   See if each line in the list intersects any of the others.            
 ;   Start with the first (index 0) line and check each one against all    
 ;   those after it for intersections.                                     
 ; 
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (while (and lins (setq sub1 (nth 0 lins)))       ; while sublist #1 exists
         (setq num 1)                              ; next entity start position
         (setq goon T)                             ; inner loop continue flag
         (setq a1 (cadr sub1))                     ; its start
         (setq b2 (caddr sub1))                    ; its end
         (while (and goon (setq rat (nth num lins))) ; while next entity exists
                (setq c3 (cadr rat))               ; its start
                (setq d4 (caddr rat))              ; its end
                (if (and a1 b2 c3 d4)
                    (setq xx (inters a1 b2 c3 d4)) ; see if it  intersects 1st
                    (setq xx ()))
 ; Ŀ
 ;   Now see if both entities are part of the same curve fit polyline,     
 ;   if they are must apply a fuzz factor to the vertex=vertex checker,    
 ;   since in this case the intersection of two segments with a common     
 ;   vertex is not neccessarily exactly equal to that vertex.              
 ; 
 ;              (if (and (equal (setq subnam (car rat)) (car sub1))
 ;                       (= (logand 2 (cdr (assoc 70 (entget subnam)))) 2))
 ;                  (setq fuzz 0.0000000001)
 ;                  (setq fuzz 0))
 ; Ŀ
 ;   Later: it now seems that the entersection of two endpoints may not    
 ;   be the same as either endpoint under any circumstances, so must       
 ;   always use a fuzz factor.                                             
 ; 
                (setq fuzz 0.0000000001)
 ; Ŀ
 ;   So: if there was an intersection, see if it was an endpoint.          
 ; 
                (if (and xx                         ; if it does intersect 1st
                        (not (or (equal xx a1 fuzz) ; and it's not a line end
                                 (equal xx b2 fuzz)
                                 (equal xx c3 fuzz)
                                 (equal xx d4 fuzz))))
                    (progn
 ; Ŀ
 ;   The two current lines crossed: call subroutine Bonk to break the      
 ;   correct line and update entities in Lins.  Also set goon to nil:      
 ;   once an entity is cut the ename from the first sublist may not be     
 ;   valid, so Lins must be updated and the inner loop must fall through   
 ;   to get a new and valid first sublist.                                 
 ; 
                         (setq goon ())            ; stop inner loop after this
                         (bonk sub1 rat xx)))      ; call bonk
                (setq num (1+ num)))               ; go to next entity
 ; Ŀ
 ;   If goon is still set then no intersection can have been found with    
 ;   the entity in the first sublist, so it can be removed from the list.  
 ;   If Goon = nil then an intersection was cut: add 1 to the counter.     
 ; 
         (if goon
            (setq lins (cdr lins))
            (setq ni (1+ ni))))
  (setvar "blipmode" blip)
  ni)                                              ; return number of breaks
 ; Ŀ
 ;   Bliste end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Bonk - take two lines and their intersection as arguments  
 ;   and cut one, then call Scrape to update the data for the cut entity   
 ;   in Lins.                                                              
 ; 
 (DEFUN BONK (lst1 lst2 intrs / last ang1 ang2 enampt ptx pty cut1 cut2 nulast)
 ; Ŀ
 ;   Save entlast, if it has subentities find and save the last one, this  
 ;   will be used by Scrape to find new entities to add to Lins.           
 ; 
  (setq last (entlast))
  (if (assoc 66 (entget last))
      (while (entnext last)
             (setq last (entnext last))))
 ; Ŀ
 ;   Get the line/polyline enames.                                         
 ; 
  (setq lin1 (car lst1))
  (setq lin2 (car lst2))
 ; Ŀ
 ;   Decide which line to cut.  Get the two angles.                        
 ; 
  (setq ang1 (angle (cadr lst1) (caddr lst1)))
  (setq ang2 (angle (cadr lst2) (caddr lst2)))
 ; Ŀ
 ;   Reduce both angles to <= 180.                                        
 ; 
  (if (< pi ang1) (setq ang1 (- ang1 pi)))
  (if (< pi ang2) (setq ang2 (- ang2 pi)))
 ; Ŀ
 ;   And see which is closest to 90.  (i.e. cut that one.)                
 ; 
  (if (< (abs (- (/ pi 2) ang1))                   ; if ang1 is closer to 90
         (abs (- (/ pi 2) ang2)))                  ; than ang2
      (progn
           (setq enampt (list lin1 intrs))         ; then break line 1
           (setq lincut lin1)                      ; remember that
           (setq ang ang1))                        ; and use angle1
      (progn
           (setq enampt (list lin2 intrs))         ; otherwise break line 2
           (setq lincut lin2)                      ; remember that
           (setq ang ang2)))                       ; and use angle2
 ; Ŀ
 ;   Now cut the line, angling the cut distances to match the line.        
 ; 
  (if (= ang (/ pi 2))
      (setq hyp chdist)
      (setq hyp (/ chdist (cos (abs (- (/ pi 2) ang))))))
  (setq cut1 (polar intrs ang hyp))
  (setq cut2 (polar intrs ang (- hyp)))
  (command "break" enampt "f" cut1 cut2)           ; break the line
 ; Ŀ
 ;   As each line or polyline is broken call Scrape to remove it from the  
 ;   data list Lins, update and replace its information.                   
 ; 
  (scrape lincut last)                   ; call scrape to update data in Lins
 (princ))
 ; Ŀ
 ;   Bonk end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Llist - takes as arguments an ename and a list, appends    
 ;   the data for the entity (and subentities, if any) to the list in      
 ;   ((ename 10 11) etc.) format.                                          
 ;   Note that must add another list for the segment between the last      
 ;   first vertices of a closed polyline.                                  
 ; 
 (DEFUN LLIST (nname linlis / nn typ clos ss start num enam sub second first)
  (setq nn (entget (setq enam nname)))
  (setq typ (cdr (assoc 0 nn)))
  (cond ((= typ "LWPOLYLINE")
         (setq linlis (append linlis (lwelis enam))))
        ((= typ "POLYLINE")
         (if (= (logand (cdr (assoc 70 nn)) 1) 1)   ; if closed
             (setq clos T))                         ; then set flag
         (setq ss (ssadd))
         (while (/= (cdr (assoc 0 nn)) "SEQEND")
                (if (/= (cdr (assoc 0 nn)) "POLYLINE")
                    (ssadd (cdr (assoc -1 nn)) ss))
                (setq nn (entget (setq enam (entnext enam)))))
         (if (and ss clos)                                         ; if closed
             (setq start (cdr (assoc 10 (entget (ssname ss 0)))))) ; save 1st
         (setq num 0)
         (while (and ss (setq enam (ssname ss num)))
                (if first
                    (progn
                         (setq sub (list (list nname first
                                (setq second (cdr (assoc 10 (entget enam)))))))
                         (setq linlis (append linlis sub))
                         (setq first second))
                    (setq first (cdr (assoc 10 (entget enam)))))
                (setq num (1+ num)))
         (if start                                                 ; if closed
             (progn
                  (setq sub (list (list nname start second)))
                  (setq linlis (append linlis sub)))))
        ((= typ "LINE")
         (setq linlis (append linlis (list (list nname (cdr (assoc 10 nn))
                                           (cdr (assoc 11 nn))))))))
 linlis)
 ; Ŀ
 ;   Llist end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Lwelis - makes a list ((ename 10 11) ...) from a           
 ;   lwpolyline.  The ename will be the same for each sublist.             
 ;   Argument: Enam, an entity name.                                       
 ;   Returns a list.                                                       
 ;   Note that must add another list for the segment between the last      
 ;   first vertices of a closed polyline.                                  
 ; 
 (DEFUN LWELIS (enam / entt sub num elev tsav suba gnulis)
  (setq entt (entget enam))
  (setq num 0)
  (while (setq sub (nth num entt))
         (setq num (1+ num))
         (cond ((and elev (= (car sub) 10))
                (setq ten (cdr sub))
                (setq suba (list enam (cdr sub) elev))
                (setq gnulis (cons suba gnulis))
                (setq elev ten))
               ((= (car sub) 10)
                (setq ten (cdr sub))
                (setq tsav ten)
                (setq elev ten))))
  (if (= 1 (logand (cdr (assoc 70 entt)) 1))   ; if closed
      (setq gnulis (cons (list enam ten tsav) gnulis)))
 gnulis)
 ; Ŀ
 ;   Lwelis end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Scrape - Update Lins: replace entity data.  Takes as       
 ;   arguments the enames of the cut entity and the entity that was        
 ;   entlast before the cut was made.  Sublists belonging to Lincut are    
 ;   removed from Lins and replaced with updated ones if the ename is      
 ;   still valid - a cut polyline is replaced with two new ones (with new  
 ;   enames) and the entity associated with the original ename is removed. 
 ;   Thus the ename must be checked to see if it is valid before trying    
 ;   to update its sublists, and any new entities must be added to Lins.   
 ; 
 (DEFUN SCRAPE (lincut last / fdap pos sub)
 ; Ŀ
 ;   First remove any entities or subentities belonging to Lincut.         
 ; 
  (setq fdap lins)
  (setq lins ())
  (setq pos 0)
  (while (setq sub (nth pos fdap))
         (setq pos (1+ pos))
         (if (/= (car sub) lincut)
             (setq lins (append lins (list sub)))))
 ; Ŀ
 ;   If Lincut is a line add it back to Lins.  Polylines are not added     
 ;   back in since a cut pline is replaced with two new entities, which    
 ;   must be found and reinserted.  Since an entget of a deleted ename     
 ;   returns nil, only update the sublist data if (entget lincut) returns   
 ;   valid entity data.                                                    
 ; 
  (if (setq entt (entget lincut))
      (progn
           (setq typ (cdr (assoc 0 (entget lincut))))
           (if (member typ '("LINE" "POLYLINE" "LWPOLYLINE"))
               (setq lins (llist lincut lins)))))
 ; Ŀ
 ;   If there is any entity after the last ename saved in Last, it is      
 ;   either the new half of a cut line or the first of two new polylines.  
 ;   In any event, add its data to lins.                                   
 ; 
  (while (setq last (entnext last))
         (setq lins (llist last lins))
         (if (assoc 66 (entget last))
             (while (/= (cdr (assoc 0 (entget last))) "SEQEND")
                    (setq last (entnext last)))))
 (princ))
 ; Ŀ
 ;   Scrape end.                                                           
 ; 

 ; Ŀ
 ;   Penguin - the friendly looking carnivore.                             
 ; 
 (DEFUN C:PENGUIN (/ *error* osmo ss num enam lins)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (command "undo" "end")
   (if shk (prompt shk))
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get a selection set of lines and similar entities.                    
 ; 
  (prompt "Select lines to chop: ")
  (setq ss (ssget '((-4 . "<or") (0 . "polyline") (0 . "lwpolyline")
                                 (0 . "line")
                    (-4 . "or>"))))
 ; Ŀ
 ;   Get the break halfwidth, turn off running osnaps so that they won't   
 ;   move the break points set by the program.                             
 ; 
  (setvar "osmode" 0)              ; so osnaps won't alter point picks
  (if (and (/= (type chdist) 'REAL)
           (/= (type chdist) 'INT))
      (setq chdist (* (misps) 1.5)))
  (setq str (strcat "Break halfwidth <" (rtos chdist 2 2) ">:"))
  (setq chds (getdist str))
  (if chds (setq chdist chds))
 ; Ŀ
 ;   Now that the operator is finished with his typically slothful input,  
 ;   start the timer.                                                      
 ; 
     (setq s (getvar "date"))
     (setq t1 (* 86400.0 (- s (fix s))))
 ; Ŀ
 ;   Call Llist to make ss into a list in ((ename pt10 pt11) etc.) format. 
 ; 
  (setq num 0)                            ; ss position counter
  (while (setq enam (ssname ss num))
         (setq lins (llist enam lins))
         (setq num (1+ num)))
 ; Ŀ
 ;   Call Bliste to find intersections between lines in the list Lins.     
 ; 
  (setq ni (bliste lins))                 ; returns number of breaks installed
 ; Ŀ
 ;   Summarize what happened, print elapsed time.                          
 ; 
  (if (zerop ni)
      (write-line "There are no useable intersections.")
      (write-line (strcat "Intersections cut: " (itoa ni))))
  (setq s (getvar "date"))
  (setq t2 (* 86400.0 (- s (fix s))))
  (write-line (strcat "Elapsed time: " (rtos (- t2 t1) 2 1) " seconds."))
  (*error* ())
 (princ))